"""A setuptools based setup module.

Copied from:
https://github.com/pypa/sampleproject
It's license applies to this file.
"""
# Copyright (c) 2016 The Python Packaging Authority (PyPA)
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.


# Always prefer setuptools over distutils
from setuptools import setup, find_packages
# To use a consistent encoding
from codecs import open
from os import path


# Get the long description from the README file
def filter_readme():
    '''Return README content with copyright at top removed'''
    lines = []
    past_copyright = False
    with open(path.join(here, 'README.md'), encoding='utf-8') as f:
        for line in f:
            if past_copyright:
                lines.append(line)
            else:
                if line == '-->\n':
                    past_copyright = True
    return ''.join(lines)


# Get program version
here = path.abspath(path.dirname(__file__))
with open(path.join(here, 'src', 'enforcer', 'VERSION'),
          encoding='utf-8') as version_file:
    version = version_file.read().strip()

long_description = filter_readme()

setup(
    name='enforcer',

    # Versioning is major.minor.fixes.  Major releases change (after 1.0.0)
    # when backward incompatibility is introduced.  Minor releases introduce
    # new features.  Fix releases introduce fixes.
    version=version,

    description='Enforce lending folder structure and file name syntax',
    long_description=long_description,

    # The project's main homepage.  Fake something since this is required.
    url='http://www.meme.com/',

    # Author details
    author='Karl O. Pinc',
    author_email='kop@meme.com',

    # Choose your license
    license='Apache 2.0',

    # See https://pypi.python.org/pypi?%3Aaction=list_classifiers
    classifiers=[
        # How mature is this project? Common values are
        #   3 - Alpha
        #   4 - Beta
        #   5 - Production/Stable
        'Development Status :: 4 - Beta',

        # Indicate who your project is intended for
        'Intended Audience :: Financial and Insurance Industry',
        'Topic :: Office/Business :: Financial',
        'Topic :: System :: Systems Administration',
        'Topic :: Utilities',

        # Pick your license as you wish (should match "license" above)
        'License :: OSI Approved :: Apache Software License',

        # Specify the Python versions you support here. In particular, ensure
        # that you indicate whether you support Python 2, Python 3 or both.
        # Google's oauth2client library is (presently) for Python 2.7,
        # 3.4, and 3.5.  Hard to say if it works for 3.6.
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.4',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',

        'Operating System :: Microsoft :: Windows',
        'Operating System :: Unix',
    ],

    # What does your project relate to?
    keywords=('filesystem check standards'),

    # You can just specify the packages manually here if your project is
    # simple. Or you can use find_packages().
    packages=find_packages('src'),
    package_dir={'': 'src'},

    # Run-time dependencies.
    # (The "python_version" here requires setuptools v20.8.1 or later.)
    install_requires=[
        'configparser',
        'google-api-python-client',
        'httplib2',
        'oauth2client',
        'ply',
        'scandir;python_version<"3.5"',
    ],

    # List additional groups of dependencies here (e.g. development
    # dependencies). You can install these using the following syntax,
    # for example:
    # $ pip install -e .[dev,test]
    # extras_require={
    #     'dev': ['check-manifest'],
    #     'test': ['coverage'],
    # },

    # If there are data files included in your packages that need to be
    # installed, specify them here.  If using Python 2.6 or less, then these
    # have to be included in MANIFEST.in as well.
    package_data={
        'enforcer': ['VERSION'],
    },

    # Additional files not otherwise included.
    data_files=[
        ('examples', ('sample_config.ini',)),
    ],

    # To provide executable scripts, use entry points in preference to the
    # "scripts" keyword. Entry points provide cross-platform support and allow
    # pip to create the appropriate form of executable for the target platform.
    entry_points={
        'console_scripts': [
            'enforcer=enforcer.enforcer:main',
        ],
    },
)
