# Copyright (C) 2015, 2018, 2020 The Meme Factory, Inc.
# http://www.karlpinc.com/

# This file is part of PGWUI_Testing.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

from pytest import (
    fixture,
)
from pyramid.testing import (
    DummyRequest,
    setUp,
    tearDown
)

from pgwui_testing import pytest_plugin_helpers


# Fixtures

@fixture
def pyramid_config():
    yield setUp()
    tearDown()


@fixture
def pyramid_request_config():
    request = DummyRequest()
    yield setUp(request=request)
    tearDown()


@fixture
def pgwui_component_entry_point():
    '''Test that the supplied pgwui component is a pgui.components entry point
    '''
    return pytest_plugin_helpers.pgwui_entry_point('pgwui.components')


@fixture
def pgwui_check_settings_entry_point():
    '''Test that the supplied pgwui component is a pgwui.check_settings
    entry point
    '''
    return pytest_plugin_helpers.pgwui_entry_point('pgwui.check_settings')
