# Copyright (C) 2018, 2020, 2021 The Meme Factory, Inc.
# http://www.karlpinc.com/

# This file is part of PGWUI_Bulk_Upload
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

'''Provide a way to configure this PGWUI component.
'''
PGWUI_COMPONENT = 'pgwui_bulk_upload'
DEFAULT_BULK_UPLOAD_ROUTE = '/bulk_upload'
DEFAULT_BULK_UPLOAD_MENU_LABEL = (
    'bulk_upload -- Upload Many Files Into PostgreSQL')
DEFAULT_MAP_FILE = 'contents.yml'
DEFAULT_LITERAL_COLUMN_HEADINGS = 'no-never'
DEFAULT_TRIM = 'choice-yes'
DEFAULT_NULL = 'choice-yes'
DEFAULT_FILE_FORMAT = 'csv'


def establish_settings(config):
    '''Setup all the defaults:
    menu label, map file
    '''
    settings = config.get_settings()
    pgwui = settings.setdefault('pgwui', dict())
    pgwui.setdefault(PGWUI_COMPONENT, dict())
    bulk_upload_settings = pgwui[PGWUI_COMPONENT]
    bulk_upload_settings.setdefault(
        'menu_label', DEFAULT_BULK_UPLOAD_MENU_LABEL)
    bulk_upload_settings.setdefault(
        'map_file', DEFAULT_MAP_FILE)
    bulk_upload_settings.setdefault(
        'literal_column_headings', DEFAULT_LITERAL_COLUMN_HEADINGS)
    bulk_upload_settings.setdefault(
        'trim', DEFAULT_TRIM)
    bulk_upload_settings.setdefault(
        'null', DEFAULT_NULL)
    bulk_upload_settings.setdefault(
        'file_format', DEFAULT_FILE_FORMAT)


def includeme(config):
    '''Pyramid configuration for PGWUI_Bulk_Upload
    '''
    establish_settings(config)
    config.add_route(PGWUI_COMPONENT, DEFAULT_BULK_UPLOAD_ROUTE)
    config.scan()
