<%doc>
  Copyright (C) 2015, 2018, 2020, 2021 The Meme Factory, Inc.
  http://www.karlpinc.com/
 
     This file is part of PGWUI_Bulk_Upload.
    
     This program is free software: you can redistribute it and/or
     modify it under the terms of the GNU Affero General Public License
     as published by the Free Software Foundation, either version 3 of
     the License, or (at your option) any later version.
    
     This program is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     Affero General Public License for more details.
    
     You should have received a copy of the GNU Affero General Public
     License along with this program.  If not, see
     <http://www.gnu.org/licenses/>.

  Template for generic bulk_upload page.
 
  Karl O. Pinc <kop@karlpinc.com>

  This template uses the following variables in it's context:

    ...
</%doc>


<%!
    from pgwui_upload_core.template_utils import show_choice
    from pgwui_common.path import asset_abspath
    import pgwui_common.exceptions as common_ex

    upload_base_mak = asset_abspath('pgwui_upload_core:templates/upload.mak')
%>

<%inherit file="${upload_base_mak}" />

<%block name="meta_keywords">
  <meta name="keywords"
        content="PGWUI bulk_upload" />
</%block>

<%block name="meta_description">
  <meta name="description"
        content="Upload into many PostgreSQL tables, assisting data cleanup, via the web." />
</%block>

<%block name="action_success">
  <p><em class="success">Successfull bulk upload</em> of ${filename};
  inserted ${inserted_rows} rows from ${len(stats)}
  files<em class="success">!</em>
  </p>

  % if len(stats) != len(relation_stats):
        <%doc> There were multiple files loaded into the same relation </%doc>
        % for (relation, count) in relation_stats:
              <p>Inserted ${count} rows into relation (${relation})</p>
        % endfor
  % endif
  % for (path, lines, relation) in stats:
        <p>Uploaded the ${lines} lines of file (${path}) into (${relation})</p>
  % endfor
</%block>

<%def name="file_errors(errors, filepath, firsterr)">
  % if filepath is None:
      <hr class="errorsep"></hr>
  % else:
      <%
      file_info = statmap[filepath]
      file_lines = file_info[0]
      relation = file_info[1]
      %>
      <hr class="errorsep"></hr>
      <%
      self.error_file_summary(len(errors), file_lines, filepath, relation)
      %>
  % endif
  <%
  self.error_items(errors, sepclass='lightsep', caution=(not firsterr))
  %>
</%def>

<%block name="error_report">
  % if e_cnt:
      <p><em class="error">${e_cnt} errors</em> found.</p>
      <%
      # Either every error has a filepath or none do
      firsterr = True
      last_filepath = None
      f_errors = []
      for error in errors:
          if isinstance(error, common_ex.UploadError):
              if error.filepath != last_filepath:
                  if last_filepath:
                      self.file_errors(f_errors, last_filepath, firsterr)
                      firsterr = False
                  last_filepath = error.filepath
                  f_errors = []
          f_errors.append(error)
      self.file_errors(f_errors, last_filepath, firsterr)
      %>
  % endif
</%block>

<h1>Upload Into Multiple Tables</h1>

<%
    form_elements = []
    self.append_elements(form_elements)

    self.upload_form(form_elements,
                     upload_nulls=show_choice(pgwui, 'null'))
%>