# Copyright (C) 2018, 2020 The Meme Factory, Inc.  http://www.karlpinc.com/

# This file is part of PGWUI_Common.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

'''Override assets based on settings
'''

import logging
import pyramid.exceptions

from . import exceptions as ex

# Logging
log = logging.getLogger(__name__)


def override_assets(config, settings):
    pgwui = settings['pgwui']
    if 'override_assets' not in pgwui:
        return []

    errors = []
    for asset, replacement in pgwui['override_assets'].items():
        try:
            config.override_asset(asset, replacement)
        except (pyramid.exceptions.ConfigurationError,
                ModuleNotFoundError) as exp:
            errors.append(ex.BadAssetOverrideError(asset, replacement, exp))
        else:
            log.debug(f'Overriding asset ({asset}) with ({replacement})')

    return errors
