<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<%doc>
  Copyright (C) 2015, 2020, 2021 The Meme Factory, Inc.
  http://www.karlpinc.com/
 
     This file is part of PGWUI_Common.
    
     This program is free software: you can redistribute it and/or
     modify it under the terms of the GNU Affero General Public License
     as published by the Free Software Foundation, either version 3 of
     the License, or (at your option) any later version.
    
     This program is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     Affero General Public License for more details.
    
     You should have received a copy of the GNU Affero General Public
     License along with this program.  If not, see
     <http://www.gnu.org/licenses/>.
 
  Base template for form that authenticates a user and accesses a db.
 
  Karl O. Pinc <kop@karlpinc.com>

  This template uses the following variables in it's context:
    havecreds   Already logged in
    user
</%doc>

<%def name="hidden_vars(csrf_token)">
    <input name="action"
           type="hidden"
           value="u"
           />
    <input type="hidden"
           name="csrf_token"
           value="${csrf_token}"
           />
</%def>

<%def name="user_row(tabindex, havecreds, user)">
      <tr>
        <td class="label">
          <label for="user_id">Username:</label>
        </td>
        <td>
          % if havecreds:
            <span id="user_id">${user}</span>
          % else:
            <input name="user"
                   tabindex="${tabindex}"
                   id="user_id"
                   type="text"
                   size="30"
                   value=""
                   />
          % endif
        </td>
      </tr>
</%def>

<%def name="password_row(tabindex, havecreds)">
      % if not havecreds:
        <tr>
          <td class="label">
            <label for="password_id">Password:</label>
          </td>
          <td>
            <input name="password"
                   tabindex="${tabindex}"
                   id="password_id"
                   type="password"
                   size="30"
                   />
          </td>
        </tr>
      % endif
</%def>
