<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<%doc>
  Copyright (C) 2014, 2015, 2018, 2020 The Meme Factory, Inc.
     http://www.karlpinc.com/
 
     This file is part of PGWUI_Common.
    
     This program is free software: you can redistribute it and/or
     modify it under the terms of the GNU Affero General Public License
     as published by the Free Software Foundation, either version 3 of
     the License, or (at your option) any later version.
    
     This program is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     Affero General Public License for more details.
    
     You should have received a copy of the GNU Affero General Public
     License along with this program.  If not, see
     <http://www.gnu.org/licenses/>.
 
  Base template for overall html structure and error handling.
 
  Karl O. Pinc <kop@meme.com>

  This template uses the following variables in it's context:

    pgwui    Dict
      urls   Dict of urls, keyed by pgwui component name

</%doc>

<%def name="navbar_content()">
  <a href="${pgwui['urls']['pgwui_home']}">HOME</a>
  % if 'pgwui_menu' in pgwui['urls']:
    | <a href="${pgwui['urls']['pgwui_menu']}">Menu</a>
  % endif
</%def>

<%def name="navbar()">
  <p class="navbar">
    ${self.navbar_content()}
  </p>
</%def>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
<head>
  <title><%block name="title" /></title>

  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
  <%block name="meta_keywords" />
  <%block name="meta_description" />
  <%block name="stylesheet_links">
    <link rel="stylesheet"
          href="${request.static_url('pgwui_common:static/pgwui.css')}"
          type="text/css" />
  </%block>
</head>

<body>
  ${self.navbar()}

  <%block name="summary_info" />

  <%block name="error_report" />

  % if db_changed:
    <%block name="action_success" />
  % endif

  <hr />

  ${self.body()}
  
  ${self.navbar()}
   
</body>
</html>
