<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<%doc>
  Copyright (C) 2015, 2020, 2021 The Meme Factory, Inc.
  http://www.karlpinc.com/
 
     This file is part of PGWUI_Common.
    
     This program is free software: you can redistribute it and/or
     modify it under the terms of the GNU Affero General Public License
     as published by the Free Software Foundation, either version 3 of
     the License, or (at your option) any later version.
    
     This program is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     Affero General Public License for more details.
    
     You should have received a copy of the GNU Affero General Public
     License along with this program.  If not, see
     <http://www.gnu.org/licenses/>.
 
  Base template for a form that reports multiple errors
  and has "logout" in the navbar
 
  Karl O. Pinc <kop@karlpinc.com>

  This template uses the following variables in it's context:
    errors      A list of UploadError exceptions.
    lines       (Optional) Number of lines in uploaded file.
                When omitted, there's no "uploaded file".
    filename    (Optional) Name of uploaded file.
    filepath    (Optional) Path of uploaded file.
    relation    (Optional) Table or view uploaded into.
    e_cnt       (Optional) Number of errors to display.
</%doc>

<%!
    from pgwui_common.path import asset_abspath

    base_mak = asset_abspath('pgwui_common:templates/base.mak')
%>

<%inherit file="${base_mak}" />

<%def name="navbar_content()">
  ${parent.navbar_content()}
  % if 'pgwui_logout' in pgwui['urls']:
    | <a href="${pgwui['urls']['pgwui_logout']}">Logout</a>
  % endif
</%def>

<%block name="summary_info">
  % if filename:
      <p>File supplied: <em class="filename">${filename}</em></p>
  % endif
</%block>

<%doc> Error reporting </%doc>

<%def name="error_file_summary(e_cnt, lines, filepath, relation)">
  % if e_cnt:
      <p><em class="error">${e_cnt} errors</em>
      % if lines == UNDEFINED or lines == 0:
          found.
      % else:
          found
        % if relation is None:
          in
        % else:
          while inserting data into ${relation} from
        % endif
        % if filepath is None:
          a file of
        % else:
          file ${filepath}, containing
        % endif
        ${lines} lines.  (Including column headings.)
      % endif
      </p>
  % endif
</%def>

<%def name="error_items(errors, sepclass='errorsep', caution=False)">
  % for error in errors:

      ## Get error attributes
      <%
      if hasattr(error, 'lineno'):
          lineno = error.lineno
      else:
          lineno = False

      if hasattr(error, 'descr') and error.descr:
          # We really do want to do this formatting here instead of in
          # the error handler.
          if error.e[-1] == ':':
              descr = ' ' + error.descr
          else:
              descr = ': ' + error.descr
      else:
          descr = ''
      %>

      % if lineno:
          % if loop.first:
              <hr class="errorsep"></hr>
          % endif
      % endif

      <p>

      % if lineno:
          % if caution or not loop.first:
              <span class="notfirstcaution">CAUTION -- This error may not be
              real; prior uploaded row(s) were rejected:</span>
             <br />
          % endif

          Line ${lineno}:
      % endif

      <em class="error">${error.e}</em>${descr}
      </p>

      ## Messages delivered here are all generated.  Allow markup.
      % if hasattr(error, 'detail'):
          <p>${error.detail | n}</p>
      % endif
      % if hasattr(error, 'data') and error.data:
          <p>Line is:</p>
          <blockquote><p>${error.data}</p></blockquote>
      % endif       

      % if not loop.last and lineno:
          <hr class="${sepclass}"></hr>
      % endif

  % endfor
</%def>

<%block name="error_report">
  <% self.error_file_summary(e_cnt, lines, None, None) %>
  <% self.error_items(errors) %>
</%block>
