# Copyright (C) 2018, 2020 The Meme Factory, Inc.  http://www.karlpinc.com/

# This file is part of PGWUI_Common.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

'''View decorators to expose useful response "variables" to templates
'''


def merge_urls(request, pgwui):
    '''Merge the urls in the settings with the urls put into the
    the pgwui portion of the response by the view
    '''
    urls = request.registry.settings['pgwui']['urls'].copy()
    pgwui.setdefault('urls', dict())
    urls.update(pgwui['urls'])
    pgwui['urls'] = urls


def base_view(wrapped):
    '''Decorator for any view which includes base.mk.
    '''
    def wrapper(request):
        '''Add variables missing but needed by base.mk to the response.
        '''
        response = wrapped(request)
        pgwui = response.get('pgwui', {})
        merge_urls(request, pgwui)
        response['pgwui'] = pgwui
        return response
    return wrapper


def errors_base_view(wrapped):
    '''Decorator for any view which includes errors_base.mk.
    '''
    def wrapper(request):
        '''Add variables needed by errors_base.mk to the response.
        '''
        return base_view(wrapped)(request)
    return wrapper


def auth_base_view(wrapped):
    '''Decorator for any view which includes auth_base.mk.
    '''
    def wrapper(request):
        '''Add variables needed by auth_base.mk to the response.
        '''
        return errors_base_view(wrapped)(request)
    return wrapper
