# Copyright (C) 2020 The Meme Factory, Inc.  http://www.karlpinc.com/

# This file is part of PGWUI_Common.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

'''Return a page that's a file in the file system
'''

import attr
from pyramid.response import FileResponse

from pgwui_common import exceptions as ex


@attr.s
class PageViewer():
    '''A class of views that return file content
    '''
    request = attr.ib()

    def page(self, page_name):
        try:
            return FileResponse(
                self.request.registry.settings['pgwui'][page_name]['source'],
                request=self.request,
                content_type='text/html',
                cache_max_age=3600)
        except FileNotFoundError as old_ex:
            raise ex.BadPageFileNotFoundError(page_name, old_ex)
        except PermissionError as old_ex:
            raise ex.BadPageFilePermissionError(page_name, old_ex)
        except IsADirectoryError as old_ex:
            raise ex.BadPageIsADirectoryError(page_name, old_ex)

    def menu_page(self):
        return self.page('menu_page')

    def home_page(self):
        return self.page('home_page')
