# Copyright (C) 2020 The Meme Factory, Inc.  http://www.karlpinc.com/

# This file is part of PGWUI_Common.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

import pytest

import pgwui_common.exceptions as common_ex


# Unit tests

@pytest.mark.unittest
def test_badsettingerror():
    '''Takes an argument'''
    # Thing is, this exception is only used by PGWUI_Server
    # when exiting the configuration context raises a configuration
    # execution error.
    assert isinstance(common_ex.BadSettingError('foo'),
                      common_ex.SetupError)


# Functional tests

@pytest.mark.integrationtest
def test_unknownsettingkeyerror():
    '''Takes an argument'''
    assert isinstance(common_ex.UnknownSettingKeyError('key'),
                      common_ex.SetupError)


@pytest.mark.integrationtest
def test_missingsettingerror():
    '''Takes an argument'''
    assert isinstance(common_ex.MissingSettingError('key'),
                      common_ex.SetupError)


@pytest.mark.integrationtest
def test_notbooleansettingerror():
    '''Takes two arguments'''
    assert isinstance(common_ex.NotBooleanSettingError('key', 'val'),
                      common_ex.SetupError)
