# Copyright (C) 2018, 2019, 2020, 2021 The Meme Factory, Inc.
# http://www.karlpinc.com/

# This file is part of PGWUI_Common.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

import pytest
from pgwui_develop import testing

import logging
import pyramid.testing
import pgwui_common.routes as routes

mock_add_route = testing.instance_method_mock_fixture('add_route')


# add_routes()

@pytest.mark.unittest
def test_add_routes_empty(mock_add_route):
    '''When there is no pgwui.routes setting nothing gets added'''
    with pyramid.testing.testConfig() as config:
        mocked_add_route = mock_add_route(config)
        routes.add_routes(config, {'pgwui': {}})

    assert not mocked_add_route.called


@pytest.mark.unittest
def test_add_routes_notempty(mock_add_route):
    '''When there is a pgwui.routes setting config.add_route() is called
    for each route'''
    test_routes = {'name1': 'route1',
                   'name2': 'route2'}
    with pyramid.testing.testConfig() as config:
        mocked_add_route = mock_add_route(config)
        routes.add_routes(config, {'pgwui': {'routes': test_routes}})

    assert mocked_add_route.call_count == len(test_routes)


@pytest.mark.unittest
def test_add_routes_menu(mock_add_route, caplog):
    '''When there is a a route for pgwui_menu, but there is a menu_page
    setting, no route is added and an INFO message is logged
    '''
    caplog.set_level(logging.DEBUG)

    test_routes = {'pgwui_menu': None, 'notused': None}
    with pyramid.testing.testConfig() as config:
        mocked_add_route = mock_add_route(config)
        routes.add_routes(config, {'pgwui': {'routes': test_routes,
                                             'menu_page': 'anything'}})

    mocked_add_route.assert_called_once()

    logs = caplog.record_tuples
    assert len(logs) == 1
    assert logs[0][1] == logging.INFO
