# Copyright (C) 2020, 2021 The Meme Factory, Inc.  http://www.karlpinc.com/

# This file is part of PGWUI_Common.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

import pytest
import logging
from pyramid.threadlocal import get_current_request

import pgwui_common.views.ex_views as ex_views
import pgwui_common.exceptions as common_ex

import pgwui_develop.testing as testing

# Activiate our pytest plugin
# pytest_plugins = ("pgwui",)


mock_exception_view_config = testing.make_mock_fixture(
    ex_views, 'exception_view_config')


# Unit tests

# bad_config_view()

@pytest.mark.unittest
def test_bad_config_view(
        caplog, pyramid_request_config, mock_exception_view_config):
    '''Modifies the request, returns an expected response, and logs
    an error
    '''
    request = get_current_request()
    result = ex_views.bad_config_view(
        common_ex.BadPageError(None, None, None), request)

    assert isinstance(result, str)
    assert request.response.status_code == 404
    assert request.response.status == ex_views.NOT_FOUND

    logs = caplog.record_tuples
    assert len(logs) == 1
    assert logs[0][1] == logging.ERROR
