# Copyright (C) 2018, 2021 The Meme Factory, Inc.  http://www.karlpinc.com/

# This file is part of PGWUI_Logout.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@meme.com>

'''Provide a way to configure PGWUI.
'''

PGWUI_COMPONENT = 'pgwui_logout'
DEFAULT_LOGOUT_ROUTE = '/logout'
DEFAULT_LOGOUT_MENU_LABEL = 'logout -- Logout from PGWUI programs'


def establish_settings(config):
    '''Add default menu information into settings when they are not present
    '''
    settings = config.get_settings()
    pgwui = settings.setdefault('pgwui', dict())
    pgwui.setdefault(PGWUI_COMPONENT, dict())
    pgwui[PGWUI_COMPONENT].setdefault(
        'menu_label', DEFAULT_LOGOUT_MENU_LABEL)


def includeme(config):
    '''Pyramid configuration for PGWUI_Logout
    '''
    establish_settings(config)
    config.add_route(PGWUI_COMPONENT, DEFAULT_LOGOUT_ROUTE)
    config.scan()
