# Copyright (C) 2020, 2021 The Meme Factory, Inc.  http://www.karlpinc.com/

# This file is part of PGWUI_Menu.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

import pytest

import pyramid.config
import pgwui_menu.pgwui_menu as pgwui_menu

from pgwui_develop import testing


# Unit tests

# establish_settings()

@pytest.mark.unittest
def test_establish_settings():
    '''A menu_label is set
    '''
    with pyramid.testing.testConfig() as config:
        pgwui_menu.establish_settings(config)
        assert config.get_settings()['pgwui']['pgwui_menu']['menu_label'] \
            == pgwui_menu.DEFAULT_MENU_MENU_LABEL


mock_establish_settings = testing.make_mock_fixture(
    pgwui_menu, 'establish_settings')

# includeme()

mock_add_static_view = testing.instance_method_mock_fixture('add_static_view')
mock_add_route = testing.instance_method_mock_fixture('add_route')
mock_scan = testing.instance_method_mock_fixture('scan')


@pytest.mark.unittest
def test_includeme(
        mock_establish_settings,
        mock_add_static_view, mock_add_route, mock_scan):
    '''add_static_view, add_route, and scan are all called
    '''
    with pyramid.testing.testConfig() as config:
        mocked_add_static_view = mock_add_static_view(config)
        mocked_add_route = mock_add_route(config)
        mocked_scan = mock_scan(config)

        pgwui_menu.includeme(config)

    mocked_add_static_view.assert_called_once()
    mocked_add_route.assert_called_once()
    mocked_scan.assert_called_once()


# Integration tests

@pytest.mark.integrationtest
def test_includeme_integration():
    config = pyramid.config.Configurator()
    pgwui_menu.includeme(config)
