"""A setuptools based setup module.

Copied from:
https://github.com/pypa/sampleproject
It's license applies to this file.
"""
# Copyright (c) 2016 The Python Packaging Authority (PyPA)
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.


# Always prefer setuptools over distutils
from setuptools import setup, find_packages
# To use a consistent encoding
from codecs import open
from os import path


# Get the long description from the README file
def filter_readme():
    '''Return README content with copyright at top removed'''
    lines = []
    past_copyright = False
    with open(path.join(here, 'README.rst'), encoding='utf-8') as f:
        for line in f:
            if past_copyright:
                lines.append(line)
            else:
                if line == '.. #End Of Copyright Marker#\n':
                    past_copyright = True
    return ''.join(lines)


here = path.abspath(path.dirname(__file__))

# Get program version
with open(path.join(here, 'src', 'pgwui_server', 'VERSION'),
          encoding='utf-8') as version_file:
    version = version_file.read().strip()

# Get the long description from the README file
long_description = filter_readme()

# Pyramid testing requirements
tests_require = [
    'pytest>=3.7.4',
    'pytest-cov',
    'pgwui_develop==' + version,
    # Integration test with other modules
    'pgwui_logout==' + version,
    'pgwui_menu==' + version,
]

setup(
    name='pgwui_server',

    # Versioning is major.minor.fixes.  Major releases change (after 1.0.0)
    # when backward incompatibility is introduced.  Minor releases introduce
    # new features.  Fix releases introduce fixes.
    version=version,

    description=(
        'Web server and WSGI app for the Postgres Web Interface programs.'),
    long_description=long_description,
    long_description_content_type='text/x-rst',

    # The project's main homepage.
    url='http://pgwui_server.readthedocs.io/',

    # Author details
    author='Karl O. Pinc',
    author_email='kop@karlpinc.com',

    # Choose your license
    license='AGPLv3+',

    # See https://pypi.python.org/pypi?%3Aaction=list_classifiers
    classifiers=[
        # How mature is this project? Common values are
        #   3 - Alpha
        #   4 - Beta
        #   5 - Production/Stable
        'Development Status :: 4 - Beta',

        # Indicate who your project is intended for
        'Environment :: Web Environment',
        'Framework :: Pyramid',
        'Intended Audience :: End Users/Desktop',
        'Intended Audience :: Information Technology',
        'Intended Audience :: Science/Research',
        'Intended Audience :: System Administrators',
        'Topic :: Database :: Front-Ends',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Scientific/Engineering',
        'Topic :: Utilities',

        # Pick your license as you wish (should match "license" above)
        ('License :: OSI Approved '
         ':: GNU Affero General Public License v3 or later (AGPLv3+)'),

        # Specify the Python versions you support here. In particular, ensure
        # that you indicate whether you support Python 2, Python 3 or both.
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.4',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
    ],

    # What does your project relate to?
    keywords=[
        'batch',
        'batch upload',
        'bulk',
        'bulk data upload',
        'bulk upload',
        'data upload',
        'database front end',
        'error reporting',
        'interface',
        'Postgres',
        'Postgres user interface',
        'Postgres web interface',
        'PostgreSQL',
        'Postgres front end',
        'transaction',
        'upload',
        'user interface',
        'web',
        'web front end',
    ],

    # You can just specify the packages manually here if your project is
    # simple. Or you can use find_packages().
    packages=find_packages('src'),
    package_dir={'': 'src'},

    # Run-time dependencies.
    install_requires=[
        'pgwui_common==' + version,
        'setuptools',                # for pkg_resources module
        'pyramid',
    ],

    # List additional groups of dependencies here (e.g. development
    # dependencies). You can install these using the following syntax,
    # for example:
    # $ pip install -e .[testing]
    extras_require={
        'testing': tests_require,
    },

    # If there are data files included in your packages that need to be
    # installed, specify them here.
    package_data={
        'pgwui_server': [
            'src/pgwui_server/VERSION',
            'examples/development.ini',
            'examples/pgwui.ini',
        ],
    },

    # To provide executable scripts, use entry points in preference to the
    # "scripts" keyword. Entry points provide cross-platform support and allow
    # pip to create the appropriate form of executable for the target platform.
    #
    # Do not register PGWUI_Server in entry_points as a PGWUI component.
    # Its configuration is manually coded.
    entry_points="""\
        [paste.app_factory]
        main = pgwui_server.pgwui_server:main
    """
    # },
)
