# Copyright (C) 2018, 2019 The Meme Factory, Inc.  http://www.karlpinc.com/

# This file is part of PGWUI_Server.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

'''Exceptions for PGWUI_Server
'''

from pgwui_common import exceptions
from pgwui_common.exceptions import SetupError


class ServerInfo(exceptions.Info):
    '''Information exceptions; which don't stop the program
    '''
    pass


class AutoconfigureConflict(ServerInfo):
    def __init__(self):
        super().__init__(
            'Autoconfigure is True and there is a pyramid.include setting')


class MissingEqualError(SetupError):
    def __init__(self, line):
        super().__init__(
            'Expecting text containing an equals (=) sign, but '
            f'instead got ({line})')


class BadValueError(SetupError):
    def __init__(self, setting, ex):
        super().__init__(
            f'Bad setting value supplied to ({setting}): {ex}')


class BadSettingsAbort(SetupError):
    def __init__(self):
        super().__init__('Aborting due to bad setting(s)')
