# Copyright (C) 2018, 2020 The Meme Factory, Inc.  http://www.karlpinc.com/

# This file is part of PGWUI_Common.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

'''Configure supporting modules and other common elements
'''

import pgwui_common.views.page_views


def configure_page(config, pgwui_settings, page_name):
    '''Setup route and view for a file given in pgwui."page_name" setting,
    which is the name of the new route.

    Only files need anything done.  URLs are used as written into the
    config, and routes and assets already exist.
    '''
    if page_name in pgwui_settings:
        page_settings = pgwui_settings[page_name]
        type = page_settings['type']
        if type == 'file':
            route_name = f'pgwui_common.{page_name}'
            config.add_route(route_name, page_settings['url_path'])
            config.add_view(pgwui_common.views.page_views.PageViewer,
                            attr=page_name, route_name=route_name)


def configure_pages(config):
    '''Setup routes and views for "pgwui.xxxx_page" settings
    '''
    pgwui_settings = config.get_settings()['pgwui']
    configure_page(config, pgwui_settings, 'home_page')
    configure_page(config, pgwui_settings, 'menu_page')


def includeme(config):
    '''Pyramid configuration for PGWUI_Common
    '''
    config.include('pyramid_mako')
    config.include('pyramid_beaker')
    config.add_static_view(
        'static/pgwui_common',
        'pgwui_common:static/',
        cache_max_age=3600)
    configure_pages(config)
    config.scan()
