# Copyright (C) 2020, 2021 The Meme Factory, Inc.  http://www.karlpinc.com/

# This file is part of PGWUI_Common.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

'''Plugin support library for PGWUI
'''

import pkg_resources


def get_component(module):
    '''Return the python distribution (package name) from a module name
    '''
    return module.split('.')[0]


def find_pgwui_components():
    '''Return list of all pgwui component names as strings
    '''
    return [get_component(entry_point.resolve().__name__) for entry_point in
            pkg_resources.iter_entry_points('pgwui.components')]


def find_pgwui_check_settings():
    '''Return dict of all pgwui.check_setting entry points, keyed by
    component
    '''
    check_settings = dict()
    for entry_point in pkg_resources.iter_entry_points('pgwui.check_settings'):
        callable = entry_point.resolve()
        check_settings[get_component(callable.__module__)] = callable
    return check_settings
