# Copyright (C) 2018, 2020 The Meme Factory, Inc.  http://www.karlpinc.com/

# This file is part of PGWUI_Common.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

'''Configure routing
'''

import logging
import pgwui_common.exceptions as ex

log = logging.getLogger(__name__)


def add_routes(config, settings):
    '''Add routes found in pgwui.routes setting

    Because settings established with Pyramid's Configurator.include()
    can be overridden by the caller, whatever configures PGWUI should
    call add_routes() after configuring all PGWUI components.
    '''
    pgwui_settings = settings['pgwui']
    if 'routes' in pgwui_settings:
        have_menu_page = 'menu_page' in pgwui_settings
        for name, route in pgwui_settings['routes'].items():
            if have_menu_page and name == 'pgwui_menu':
                log.info(ex.MenuPageInRoutes())
            else:
                config.add_route(name, route)
