<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<%doc>
  Copyright (C) 2015, 2020, 2021 The Meme Factory, Inc.
  http://www.karlpinc.com/
 
     This file is part of PGWUI_Common.
    
     This program is free software: you can redistribute it and/or
     modify it under the terms of the GNU Affero General Public License
     as published by the Free Software Foundation, either version 3 of
     the License, or (at your option) any later version.
    
     This program is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     Affero General Public License for more details.
    
     You should have received a copy of the GNU Affero General Public
     License along with this program.  If not, see
     <http://www.gnu.org/licenses/>.
 
  Base template for form that authenticates a user and accesses a db.
 
  Karl O. Pinc <kop@karlpinc.com>

  This template uses the following variables in it's context:
    havecreds   Already logged in
    errors      A list of UploadError exceptions.
    lines       (Optional) Number of lines in uploaded file.
                When omitted, there's no "uploaded file".
    filename    (Optional) Name of uploaded file.
    filepath    (Optional) Path of uploaded file.
    relation    (Optional) Table or view uploaded into.
    e_cnt       (Optional) Number of errors to display.

    For use with upload_form:
    csrf_token  Token for detecting CSRF.
    db_changed  Boolean. Whether the db was changed.
    session_expired  Boolean.  Whether the session has expired.
    last_key     Token to detect duplicate uploads.
    db
    user
    csv_value
    tab_value
    tab_checked
    csv_checked
    upload_null
    null_rep
</%doc>

<%!
    from pgwui_common.path import asset_abspath

    errors_base_mak = asset_abspath('pgwui_common:templates/errors_base.mak')
    auth_parts_mak = asset_abspath('pgwui_common:templates/auth_parts.mak')
%>

<%inherit file="${errors_base_mak}" />
<%namespace file="${auth_parts_mak}"
            name="auth_parts"
            inheritable="True" />

<%def name="upload_form(extra_rows=[], upload_nulls=True)">
  <form action="" enctype="multipart/form-data" method="post">
    <div>
    ${self.auth_parts.hidden_vars(csrf_token)}
    % if (db_changed or session_expired) and last_key:
      <input type="hidden"
             name="last_key"
             value="${last_key}"
             />
    % endif
    </div>

    <table>
      <tr>
        <td class="label">
          <label for="db_id">Database:</label>
        </td>
        <td>
          <input name="db"
                 tabindex="1"
                 id="db_id"
                 type="text"
                 size="30"
                 value="${db}"
                 />
        </td>
      </tr>
      ${self.auth_parts.user_row(2, havecreds, user)}
      <% tab_index = 3 %>
      ${self.auth_parts.password_row(tab_index, havecreds)}

      % for row in extra_rows:
        <%
          tab_index += 1
        %>
        ${row(tab_index) | n}
      % endfor

      <tr>
        <td class="label">Uploaded Data Format:</td>
        <td>
          <input name="upload_fmt"
                 id="upload_fmt_csv_id"
                 tabindex="${tab_index + 1}"
                 type="radio"
                 value="${csv_value}"
                 ${csv_checked | n}
                 />
          <label class="label" for="upload_fmt_csv_id">CSV</label>
          <br />
          <input name="upload_fmt"
                 id="upload_fmt_tab_id"
                 tabindex="${tab_index + 2}"
                 type="radio"
                 value="${tab_value}"
                 ${tab_checked | n}
                 />
          <label class="label" for="upload_fmt_tab_id">Tab delimited</label>
        </td>
      </tr>
      % if upload_nulls:
        <tr>
          <td class="label">
            <label for="upload_null_id">Upload NULL Values: </label>
          </td>
          <td>
            <input name="upload_null"
                   id="upload_null_id"
                   tabindex="${tab_index + 3}"
                   type="checkbox"
                   ${upload_null | n}
                   />
          </td>
        </tr>
        <tr>
          <td class="label">
            <label for="null_rep_id">NULL Representation: </label>
          </td>
          <td>
            <input name="null_rep"
                   id="null_rep_id"
                   tabindex="${tab_index + 4}"
                   type="text"
                   size="10"
                   value="${null_rep}"
                   />
          </td>
        </tr>
      % endif
      <tr>
        <td class="label">
          <label for="datafile_id">
            File to upload:
          </label>
        </td>
        <td colspan="2">
          <input name="datafile"
                 tabindex="${tab_index + 5}"
                 id="datafile_id"
                 type="file"
                 size="75"
                 />
        </td>
      </tr>
    </table>

    <p>
      <input value="Upload" tabindex="${tab_index + 6}" type="submit" />
    </p>
  </form>
</%def>
