# Copyright (C) 2020 The Meme Factory, Inc.  http://www.karlpinc.com/

# This file is part of PGWUI_Common.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

'''Views for exceptions that are raised
'''

import logging
from pyramid.view import exception_view_config

from pgwui_common import exceptions as ex

NOT_FOUND = '404 Not Found'

# Logging
log = logging.getLogger(__name__)


@exception_view_config(ex.BadPageError, renderer='string')
def bad_config_view(ex, request):
    request.response.status_code = 404
    request.response.status = NOT_FOUND
    log.error(f'{ex}:{ex.ex}')
    return f'PGWUI Configuration Error:\n{ex}:\n{ex.ex}'
