# Copyright (C) 2018, 2021 The Meme Factory, Inc.  http://www.meme.com/

# This file is part of PGWUI_Common.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@meme.com>

import pytest
from pyramid.path import AssetResolver

import pgwui_common.path
from pgwui_develop import testing

MockAssetResolver = testing.make_mock_fixture(
    pgwui_common.path, 'AssetResolver')


# Unit tests

# asset_abspath()

@pytest.mark.unittest
def test_asset_abspath(MockAssetResolver):
    '''Calls asset_resolver.resolve()
    '''
    asset_resolver = MockAssetResolver(None)
    MockAssetResolver.return_value = asset_resolver
    pgwui_common.path.asset_abspath(None)

    asset_resolver.resolve.assert_called_once()


# Integration tests

# asset_abspath()

@pytest.mark.integrationtest
def test_asset_abspath_integration():
    '''Returns what pyramid's asset resolver returns'''
    asset_resolver = AssetResolver(None)
    asset = 'pgwui_common:templates/base.mk'
    answer = asset_resolver.resolve(asset).abspath()
    result = pgwui_common.path.asset_abspath(asset)
    assert result == answer
