# Copyright (C) 2018, 2020, 2021 The Meme Factory, Inc.
# http://www.karlpinc.com/

# This file is part of PGWUI_Copy
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

'''Provide a way to configure this PGWUI component.
'''
PGWUI_COMPONENT = 'pgwui_copy'
DEFAULT_COPY_ROUTE = '/copy'
DEFAULT_COPY_MENU_LABEL = 'copy -- Copy a Schema Between Databases'
DEFAULT_BIN = '/usr/bin'


def build_sensitive_dbs(pgwui, copy_settings):
    if 'sensitive_dbs' in copy_settings:
        s_dbs = copy_settings['sensitive_dbs']
        if isinstance(s_dbs, list):
            return s_dbs
        return [s_dbs]
    return [pgwui.get('default_db', '')]


def establish_settings(config):
    '''Add default menu information into settings when they are not present
    '''
    settings = config.get_settings()
    pgwui = settings.setdefault('pgwui', dict())
    pgwui.setdefault(PGWUI_COMPONENT, dict())
    copy_settings = pgwui[PGWUI_COMPONENT]

    copy_settings.setdefault(
        'menu_label', DEFAULT_COPY_MENU_LABEL)
    copy_settings.setdefault(
        'default_source_db', pgwui.get('default_db', ''))
    copy_settings['sensitive_dbs'] = \
        [db.lower() for db in build_sensitive_dbs(pgwui, copy_settings)]
    copy_settings.setdefault(
        'default_target_db', '')
    copy_settings.setdefault(
        'default_schema', '')
    copy_settings.setdefault(
        'bin', DEFAULT_BIN)


def includeme(config):
    '''Pyramid configuration for PGWUI_Copy
    '''
    establish_settings(config)
    config.add_route(PGWUI_COMPONENT, DEFAULT_COPY_ROUTE)
    config.scan()
