<%doc>
  Copyright (C) 2014, 2015, 2018, 2021 The Meme Factory, Inc.
  http://www.karlpinc.com/
 
     This file is part of PGWUI_Copy.
    
     This program is free software: you can redistribute it and/or
     modify it under the terms of the GNU Affero General Public License
     as published by the Free Software Foundation, either version 3 of
     the License, or (at your option) any later version.
    
     This program is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     Affero General Public License for more details.
    
     You should have received a copy of the GNU Affero General Public
     License along with this program.  If not, see
     <http://www.gnu.org/licenses/>.

  Template for copying a schema between databases
 
  Karl O. Pinc <kop@karlpinc.com>

  This template uses the following variables in it's context:
    havecreds   Already logged in
    crfs_token
    user
    db_changed (used by base.mk)

    schema
    from_db
    to_db
    overwrite
    force
</%doc>

<%!
    from pgwui_common.path import asset_abspath

    errors_base_mak = asset_abspath('pgwui_common:templates/errors_base.mak')
    auth_parts_mak = asset_abspath('pgwui_common:templates/auth_parts.mak')
%>

<%inherit file="${errors_base_mak}" />
<%namespace file="${auth_parts_mak}"
            name="auth_parts"
            inheritable="True" />

<%block name="title">${pgwui['pgwui_copy']['menu_label']}</%block>
<%block name="meta_keywords">
  <meta name="keywords"
        content="PGWUI copy schema PostgreSQL" />
</%block>

<%block name="meta_description">
  <meta name="description"
        content="PostgreSQL Web User Interface, Copy a Schema Between Databases" />
</%block>


<%block name="action_success">
   <p><em class="success">The ${schema} schema has been copied</em>
      from the ${from_db} db to the ${to_db}
       db<em class="success">!</em></p>
</%block>

<h1>Copy A Schema Between Databases</h1>


<form action="" enctype="multipart/form-data" method="post">
  <div>
  ${self.auth_parts.hidden_vars(csrf_token)}
  </div>

  <table>
      ${self.auth_parts.user_row(1, havecreds, user)}
      ${self.auth_parts.password_row(2, havecreds)}

    ## A blank table row for spacing
    <tr><td/><td/></tr>
    <tr>
      <td class="label">
        <label for="schema_id">Schema To Copy:</label>
      </td>
      <td>
        <input id="schema_id"
               name="schema"
               tabindex="3"
               type="text"
               size="30"
               value="${schema}"
               />
      </td>
    </tr>
    <tr>
      <td class="label">
        <label for="from_db_id">From Database:</label>
      </td>
      <td>
        <input id="from_db_id"
               name="from_db"
               tabindex="4"
               type="text"
               size="30"
               value="${from_db}"
               />
      </td>
    </tr>
    <tr>
      <td class="label">
        <label for="to_db_id">To Database:</label>
      </td>
      <td>
        <input id="to_db_id"
               name="to_db"
               tabindex="5"
               type="text"
               size="30"
               value="${to_db}"
               />
      </td>
    </tr>
    <tr>
      <td class="label">
        <label for="overwrite_id">Overwrite destination schema<span
                                  style="caution">*</span>:</label>
      </td>
      <td>
        <input name="overwrite"
               tabindex="6"
               id="overwrite_id"
               type="checkbox"
               ${overwrite | n}
               />
      </td>
    </tr>
    <tr>
      <td class="label">
        <label for="force_id">Allow Copy To Sensitive DBs:</label>
        </td>
      <td>
        <input name="force"
               tabindex="7"
               id="force_id"
               type="checkbox"
               ${force | n}
                />
      </td>
    </tr>
  </table>

  <p>
    <input value="Copy" tabindex="20" type="submit" />
  </p>
    
</form>

<p>
* <span class="caution">CAUTION: Overwriting an existing schema will
cause deletion of all data and objects outside of the destination
schema which relate to any overwritten content.</span>
</p>
