# Copyright (C) 2021 The Meme Factory, Inc.  http://www.karlpinc.com/

# This file is part of PGWUI_Copy.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

import os
import pytest

import pgwui_copy.utils as utils
from pgwui_develop import testing


# Activiate the PGWUI pytest plugin
pytest_plugins = ("pgwui",)


# Mocks
mock_strerror = testing.make_mock_fixture(os, 'strerror')


# translate_retcode

@pytest.mark.unittest
def test_translate_retcode_negative():
    '''A negative retcode returns a string
    '''
    result = utils.translate_retcode(-1)
    assert isinstance(result, str)


@pytest.mark.unittest
def test_transate_retcode_nonnegative(mock_strerror):
    '''A non-negative retcode calls strerror
    '''
    utils.translate_retcode(1)
    mock_strerror.assert_called_once()


mock_translate_retcode = testing.make_mock_fixture(utils, 'translate_retcode')
