# Copyright (C) 2018, 2019, 2020, 2021 The Meme Factory, Inc.
# http://www.karlpinc.com/

# This file is part of PGWUI_Copy.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

import pytest
from pyramid.testing import DummyRequest
from pgwui_copy.views import copy

# Activiate our pytest plugin
pytest_plugins = ("pgwui",)


# Constants
TEST_SETTINGS = {
    'pgwui': {
        'host': 'pgwui.example.com',
        'port': '6543',
        'urls': {},
        'pgwui_copy': {
            'default_schema': 'example_schema',
            'default_source_db': 'example_from_db',
            'default_target_db': 'example_to_db',
            'bin': '/test/bin/path',
        }
    }
}


# Tests

# copy_view()

# Integration tests
class MockPopen():
    def wait(self):
        return True


class MockSubprocess():
    def Popen(*args, **kwargs):
        return MockPopen()


@pytest.mark.integrationtest
def test_copy_schema_view(monkeypatch):

    monkeypatch.setattr(copy, 'subprocess', MockSubprocess)

    request = DummyRequest()
    request.registry.settings = TEST_SETTINGS

    response = copy.copy_schema_view(request)

    assert isinstance(response, dict)
    assert 'pgwui' in response
