# Copyright (C) 2018, 2021 The Meme Factory, Inc.  http://www.karlpinc.com/

# This file is part of PGWUI_Core.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

import pytest
from pgwui_core import core


@pytest.mark.unittest
def test_userinitialpost_init():
    default_db = 'defaultdb'
    settings = {'pgwui': {'default_db': default_db}}
    uip = core.UserInitialPost().build(settings)
    assert uip.db == default_db
    assert uip.user == ''
    assert uip.password == ''


@pytest.mark.integrationtest
def test_dummy():
    '''Exists only so tox sees a non-integration test
    '''
    assert True
