# Copyright (C) 2018, 2019, 2020 The Meme Factory, Inc.
# http://www.karlpinc.com/

# This file is part of PGWUI_Logout.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

import pytest

import pyramid.config
from pyramid.threadlocal import get_current_request
import pgwui_logout.pgwui_logout as pgwui_logout


# Activiate our pytest plugin
pytest_plugins = ("pgwui",)


# Module packaging test

def test_pgwui_upload_is_pgwui_component(pgwui_component_entry_point):
    '''Ensure that pgwui_upload is a pgwui.component entry point
    '''
    assert pgwui_component_entry_point('pgwui_logout') is True


# Functional tests

# includeme()

@pytest.mark.integrationtest
def test_includeme_functional(pyramid_request_config):
    '''Sets a route for 'logout'
    '''
    pgwui_logout.includeme(pyramid_request_config)
    request = get_current_request()

    logout_path = request.route_path('pgwui_logout')
    assert logout_path == pgwui_logout.DEFAULT_LOGOUT_ROUTE


# Integration tests

@pytest.mark.integrationtest
def test_includeme_integration():
    '''Does not blow up
    '''
    config = pyramid.config.Configurator()
    pgwui_logout.includeme(config)
