# Copyright (C) 2018, 2020 The Meme Factory, Inc.  http://www.karlpinc.com/

# This file is part of PGWUI_Logout.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

from pyramid.testing import DummyRequest

from pgwui_common import includeme
from pgwui_logout.views import logout


# Activiate our pytest plugin
pytest_plugins = ("pgwui",)


# Integration tests

# logout_view()

def test_logout_view(pyramid_config):
    '''Deletes the session, returns no errors'''

    class MockSession():
        def __init__(self):
            self.delete_called = False

        def delete(self):
            self.delete_called = True

    session = MockSession()
    request = DummyRequest()
    request.session = session
    request.registry.settings['pgwui'] = {'pgwui_logout': None,
                                          'home_page': {'type': 'URL',
                                                        'source': '/'},
                                          'urls': {}}
    includeme(pyramid_config)
    result = logout.logout_view(request)
    del result['pgwui']  # Remove variables added by pgwui view decorators

    assert session.delete_called is True
    assert result == {}
