# Copyright (C) 2018, 2019, 2020 The Meme Factory, Inc.
# http://www.karlpinc.com/

# This file is part of PGWUI_Server.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

import pytest

import pgwui_logout
import pgwui_menu

import pgwui_server.pgwui_server as pgwui_server


# Mark all tests as "integrationtest"
pytestmark = pytest.mark.integrationtest

# Constants

TEST_SETTINGS = {
    'pgwui.validate_hmac': 'False',
    'pgwui.dry_run': 'False',
}

REFERENCE_SETTINGS = {
    'pgwui.pg_host': '',
    'pgwui.pg_port': '5432',
    'pgwui.default_db': 'template1',
    'pgwui.autoconfigure': 'True',
    'pgwui.dry_run': 'False',
    'pgwui.validate_hmac': 'False',
    # 'pgwui.home_page': {         # The default
    #      'type': 'URL',
    #      'source': '/'},
    # 'pgwui.menu_page': {         # An example
    #      'type': 'URL',
    #      'source': '/'},
    # 'pgwui.route_prefix': '',    # The default
    # 'pgwui.routes': {            # An example
    #      'pgwui_logout': '/logout',
    #      'pgwui_upload': '/upload'}
    # 'pgwui.pgwui_menu': {        # An example
    #      'order': ['pgwui_upload',
    #               'pgwui_logout'],
    # 'pgwui_upload': {      # The defaults
    #     'literal_column_headings': 'off',
    #     'menu_label': 'upload -- Upload File Into Database'},
}


# Integration tests
def test_main_integrated():
    '''Does not raise errors or warnings'''
    pgwui_server.main({}, **TEST_SETTINGS)


# Helper functions

def check_route(config, name, expected):
    route_i = config.introspector.get('routes', name)
    if route_i is None:
        assert expected is None
    else:
        assert route_i['pattern'] == expected


def updated_dict(old, new):
    updated = old.copy()
    updated.update(new)
    return updated


@pytest.mark.parametrize(
    ('settings', 'logout_path', 'menu_path', 'menu_page_path'), [
        (REFERENCE_SETTINGS,
         pgwui_logout.pgwui_logout.DEFAULT_LOGOUT_ROUTE,
         pgwui_menu.pgwui_menu.DEFAULT_MENU_ROUTE,
         None),
        (updated_dict(REFERENCE_SETTINGS,
                      {'pgwui.route_prefix': '/foo',
                       'pgwui.menu_page': {'type': 'file',
                                           'source': '/tmp/nofile.html',
                                           'url_path': '/menu'}}),
         'foo' + pgwui_logout.pgwui_logout.DEFAULT_LOGOUT_ROUTE,
         'foo' + pgwui_menu.pgwui_menu.DEFAULT_MENU_ROUTE,
         '/menu')])
def test_pgwui_server_config_no_route_prefix(
        settings, logout_path, menu_path, menu_page_path):
    '''The given route_prefix is applied to the routes
    '''
    config = pgwui_server.pgwui_server_config(settings)
    config.commit()
    config.end()

    check_route(config, 'pgwui_logout', logout_path)
    check_route(config, 'pgwui_menu', menu_path)
    check_route(config, 'pgwui_common.menu_page', menu_page_path)
