# Copyright (C) 2020 The Meme Factory, Inc.  http://www.karlpinc.com/

# This file is part of PGWUI_Upload.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

from pgwui_core import exceptions as core_ex


# Upload related exceptions

class NoTableError(core_ex.SetupError):
    '''No table uploaded'''
    def __init__(self, e, descr='', detail=''):
        super(NoTableError, self).__init__(e, descr, detail)


class BadTableError(core_ex.SetupError):
    '''Supplied name does not work for a table or view'''
    def __init__(self, e, descr='', detail=''):
        super(BadTableError, self).__init__(e, descr, detail)


class MissingTableError(BadTableError):
    '''The supplied table or view does not exist'''
    def __init__(self, e, descr='', detail=''):
        super(MissingTableError, self).__init__(e, descr, detail)


class MissingSchemaError(BadTableError):
    '''The schema portion of the supplied table or view does not exist'''
    def __init__(self, e, descr='', detail=''):
        super(MissingSchemaError, self).__init__(e, descr, detail)


class CannotInsertError(BadTableError):
    '''Cannot insert into the supplied table or view'''
    def __init__(self, e, descr='', detail=''):
        super(CannotInsertError, self).__init__(e, descr, detail)


class BadHeadersError(core_ex.SetupError):
    '''The headers in the uploaded file are bad.'''
    def __init__(self, e, descr='', detail=''):
        super(BadHeadersError, self).__init__(e, descr, detail)
