<%doc>
  Copyright (C) 2015, 2018, 2020, 2021 The Meme Factory, Inc.
  http://www.karlpinc.com/
 
     This file is part of PGWUI_Upload.
    
     This program is free software: you can redistribute it and/or
     modify it under the terms of the GNU Affero General Public License
     as published by the Free Software Foundation, either version 3 of
     the License, or (at your option) any later version.
    
     This program is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     Affero General Public License for more details.
    
     You should have received a copy of the GNU Affero General Public
     License along with this program.  If not, see
     <http://www.gnu.org/licenses/>.

  Template for generic upload page.
 
  Karl O. Pinc <kop@karlpinc.com>

  This template uses the following variables in it's context:

    ask_about_literal_cols

</%doc>


<%!
    from pgwui_upload_core.template_utils import show_choice
    from pgwui_common.path import asset_abspath

    upload_base_mak = asset_abspath('pgwui_upload_core:templates/upload.mak')
%>

<%inherit file="${upload_base_mak}" />

<%block name="meta_keywords">
  <meta name="keywords"
        content="PGWUI generic table upload" />
</%block>

<%block name="meta_description">
  <meta name="description"
        content="Upload a file into a PostgreSQL table." />
</%block>

<%block name="action_success">
  <p><em class="success">Table (${table})
  successfully updated</em> from a file containing ${lines}
  lines<em class="success">!</em>  (Including column headings.)
  </p>
</%block>

<h1>Upload File Into Table Or View</h1>

<%def name="table_row(tab_index)">
      <tr>
        <td class="label">
          <label for="table_id">Table or View:</label>
        </td>
        <td>
          <input name="table"
                 tabindex="${tab_index}"
                 id="table_id"
                 type="text"
                 size="30"
                 value="${table}"
                 />
        </td>
      </tr>
</%def>

<%
    form_elements = [table_row]
    self.append_elements(form_elements)

    self.upload_form(form_elements,
                     upload_nulls=show_choice(pgwui, 'null'))
%>
