# Copyright (C) 2019, 2020, 2021 The Meme Factory, Inc.
# http://www.karlpinc.com/

# This file is part of PGWUI_Upload.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

import pytest
import pyramid.testing

import pgwui_upload.pgwui_upload as pgwui_upload

from pgwui_develop import testing

# Activiate our pytest plugin
pytest_plugins = ("pgwui",)


# Module packaging test

def test_pgwui_upload_is_pgwui_component(pgwui_component_entry_point):
    '''Ensure that pgwui_upload is a pgwui.component entry point
    '''
    assert pgwui_component_entry_point('pgwui_upload') is True


# establish_settings()

@pytest.mark.unittest
def test_establish_settings_default():
    '''The settings get the module's default value when no settings exist
    '''
    with pyramid.testing.testConfig() as config:

        pgwui_upload.establish_settings(config)

        new_settings = config.get_settings()
    assert new_settings['pgwui']['pgwui_upload']['menu_label'] \
        == pgwui_upload.DEFAULT_UPLOAD_MENU_LABEL


@pytest.mark.unittest
def test_establish_settings_no_default():
    '''The settings keep their value when they exist
    '''
    test_menu_label = 'test label'

    with pyramid.testing.testConfig() as config:
        sample_settings = config.get_settings()

        sample_settings['pgwui'] = dict()
        sample_settings['pgwui']['pgwui_upload'] = dict()
        sample_settings['pgwui']['pgwui_upload']['menu_label'] \
            = test_menu_label

        pgwui_upload.establish_settings(config)

        new_settings = config.get_settings()
    assert new_settings['pgwui']['pgwui_upload']['menu_label'] \
        == test_menu_label


mock_establish_settings = testing.make_mock_fixture(
    pgwui_upload, 'establish_settings')


# includeme()

mock_add_route = testing.instance_method_mock_fixture('add_route')
mock_scan = testing.instance_method_mock_fixture('scan')


@pytest.mark.unittest
def test_includeme(mock_establish_settings, mock_add_route, mock_scan):
    '''establish_settings, add_route, and scan are all called
    '''
    with pyramid.testing.testConfig() as config:
        mocked_add_route = mock_add_route(config)
        mocked_scan = mock_scan(config)

        pgwui_upload.includeme(config)

    mock_establish_settings.assert_called_once()
    mocked_add_route.assert_called_once()
    mocked_scan.assert_called_once()
