# Copyright (C) 2020, 2021 The Meme Factory, Inc.  http://www.karlpinc.com/

# This file is part of PGWUI_Upload_Core.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

from pgwui_common import checkset
from pgwui_upload_core import exceptions as upload_core_ex


UPLOAD_SETTINGS = ['menu_label',
                   'literal_column_headings',
                   'trim',
                   'null',
                   'file_format'
                   ]
REQUIRED_SETTINGS = []
BOOLEAN_SETTINGS = []
BOOLEAN_CHOICE_SETTINGS = ['literal_column_headings',
                           'trim',
                           'null']


def validate_file_format(component, errors, settings):
    '''Make sure the values are those allowed
    '''
    value = settings.get('file_format')
    if value not in ('csv', 'tab'):
        errors.append(
            upload_core_ex.BadFileFormatError(component, value))


def check_settings(
        component, all_setngs, required_setngs, boolean_setngs,
        boolean_choice_setngs, component_config):
    '''Check that all pgwui_upload specific settings are good.
    This includes:
      checking for unknown settings
      checking for missing required settings
      checking the boolean settings
      checking that the values of other settings are valid
    '''
    errors = []
    errors.extend(checkset.unknown_settings(
        component, all_setngs, component_config))
    errors.extend(checkset.require_settings(
        component, required_setngs, component_config))
    errors.extend(checkset.boolean_settings(
        component, boolean_setngs, component_config))
    errors.extend(checkset.boolean_choice(
        component, boolean_choice_setngs, component_config))

    return errors
