<%doc>
  Copyright (C) 2015, 2018, 2020, 2021 The Meme Factory, Inc.
  http://www.karlpinc.com/
 
     This file is part of PGWUI_Upload_Core.
    
     This program is free software: you can redistribute it and/or
     modify it under the terms of the GNU Affero General Public License
     as published by the Free Software Foundation, either version 3 of
     the License, or (at your option) any later version.
    
     This program is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     Affero General Public License for more details.
    
     You should have received a copy of the GNU Affero General Public
     License along with this program.  If not, see
     <http://www.gnu.org/licenses/>.

  Template for generic upload pages.
 
  Karl O. Pinc <kop@karlpinc.com>

  This template uses the following variables in it's context:

    ask_about_literal_cols

  It makes available:

    append_elements(elementlist)  Adds form elements to the end of the list

</%doc>


<%!
    from pgwui_upload_core.template_utils import show_choice
    from pgwui_common.path import asset_abspath

    auth_base_mak = asset_abspath('pgwui_common:templates/auth_base.mak')
%>

<%inherit file="${auth_base_mak}" />

<%block name="title">${pgwui['upload_settings']['menu_label']}</%block>

<%def name="trim_row(tab_index)">
  % if show_choice(pgwui, 'trim'):
      <tr>
        <td class="label">
          <label for="trim_upload_id">Trim Leading/Trailing Spaces:</label>
        </td>
        <td>
          <input name="trim_upload"
                 tabindex="${tab_index}"
                 id="trim_upload_id"
                 type="checkbox"
                 ${trim_upload | n}
                 />
        </td>
      </tr>
  % endif
</%def>

<%def name="append_elements(form_elements)">
    <% form_elements.append(trim_row) %>
    % if show_choice(pgwui, 'literal_column_headings'):
        <%def name="literal_row(tab_index)">
              <tr>
                <td class="label">
                  <label for="literal_col_headings_id">Literal
                         Uploaded Column Headings:</label>
                </td>
                <td>
                  <input name="literal_col_headings"
                         tabindex="${tab_index}"
                         id="literal_col_headings_id"
                         type="checkbox"
                         ${literal_col_headings | n}
                         />
                </td>
              </tr>
        </%def>

        <% form_elements.append(literal_row) %>
    % endif
</%def>
