# Copyright (C) 2019, 2020, 2021 The Meme Factory, Inc.
# http://www.karlpinc.com/

# This file is part of Pgwui_Upload_Core.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

import pytest
import pyramid.testing

import pgwui_upload_core.pgwui_upload_core as pgwui_upload_core

from pgwui_develop import testing

# Activiate our pytest plugin
pytest_plugins = ("pgwui",)


# Module packaging test

def test_pgwui_upload_core_is_pgwui_component(pgwui_component_entry_point):
    '''Ensure that pgwui_upload_core is a pgwui.component entry point
    '''
    assert pgwui_component_entry_point('pgwui_upload_core') is True


# includeme()

mock_scan = testing.instance_method_mock_fixture('scan')


@pytest.mark.unittest
def test_includeme(mock_scan):
    '''scan() is called
    '''
    with pyramid.testing.testConfig() as config:
        mocked_scan = mock_scan(config)

        pgwui_upload_core.includeme(config)

    mocked_scan.assert_called_once()
